program ArrayFunction;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  Tools1v2 in 'Tools1v2.pas',
  AnsiTo866 in 'AnsiTo866.pas';

// =========================================================
//     
// =========================================================

const MaxNumArray = 20;
//   
var XArray   : array [0..MaxNumArray] of double;
//     
var YArray   : array [0..MaxNumArray] of double;
//    
var ZArray   : array [0..MaxNumArray] of double;

// =========================================================
//   
// =========================================================
//   
var CmdChar  : char;

// =========================================================
//       
// =========================================================
//      
procedure ShowMenu();
begin
WriteLn;
WriteLnRus (' /COMMAND MENU:'); WriteLn;
WriteLnRus ('H - /Help');
WriteLnRus ('V -   X  Y /Show array X and Y');
WriteLnRus ('W -    X / Write to array X');
WriteLnRus ('R -    X / Write random array X');
WriteLnRus ('S -  Y = SIN(X) / ompute Y = SIN(X)');
WriteLnRus ('C -  Y = COS(X) / ompute Y = COS(X)');
WriteLnRus ('E -  Y = EXP(X) / ompute Y = EXP(X)');
WriteLnRus ('I -  Y = Si(X) / ompute Y = Si(X)');
WriteLnRus ('M -  Min-Max   X /Find Min-Max in array X');
WriteLnRus ('+ -   X  /Sorted Up array X');
WriteLnRus ('- -   X  /Sorted Down array X');
WriteLnRus ('Q - /Quit');
WriteLn;
end;

// =========================================================
//    
// =========================================================

// ---------------------------------------------------------
//   (EXP, SIN, COS, SI)    
function TaylorFunc(RqFunc : char; RqX : double): double;
//    
const FunMaxNum = 31;
//     SIN  SI  
const SinKoef : array [0..FunMaxNum] of integer =
 ( 0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1,
   0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1
 );
//     COS  
const CosKoef : array [0..FunMaxNum] of integer =
 ( 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1, 0,
   1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1, 0
 );
var Ind       : integer;  //  
    Factorial : double;   //  
    XPower    : double;   //   RqX
begin
 Result    := 0;  //    
 Ind       := 0;  //  
 Factorial := 1;  //   
 XPower    := 1;  // RqX   
 repeat
    case UpCase(RqFunc)of
      'E' : begin   //   EXP
               Result := Result + XPower / Factorial;
            end;
      'S' : begin   //   SIN
               case SinKoef[Ind] of
               - 1 : Result := Result - XPower / Factorial;
                 1 : Result := Result + XPower / Factorial;
               end;
            end;
      'C' : begin   //   COS
               case CosKoef[Ind] of
               - 1 : Result := Result - XPower / Factorial;
                 1 : Result := Result + XPower / Factorial;
               end;
            end;
      'I' : begin   //   SI ( )
               case SinKoef[Ind] of
               - 1 : Result := Result - XPower / Factorial / Ind;
                 1 : Result := Result + XPower / Factorial / Ind;
               end;
            end;
    end;
    //      
    //   (Ind),  (Factorial)
    //      Ind (XPower)
    Ind := Ind + 1;                 //  
    Factorial := Factorial * Ind;   // 
    XPower    := XPower * RqX;      //    Ind
 until (Ind > FunMaxNum);
end; // of function

// ---------------------------------------------------------
//   Y  TaylorFunc(X),  
// Z  
procedure TaylorFuncToYArray (RqFunc   : char;
                              RqXArray : array of double;
                              var RqYArray, RqZArray : array of double);
var Ind  : integer;  //  
begin
 for Ind:= Low(RqXArray) to High(RqXArray) do
 begin
   case RqFunc of
   'E' : begin
            //   EXP
            RqYArray[Ind] := TaylorFunc(RqFunc, RqXArray[Ind]);
            //      
            RqZArray[Ind] := RqYArray[Ind] - EXP(RqXArray[Ind]);
         end;
   'S' : begin
            //   SIN
            RqYArray[Ind] := TaylorFunc(RqFunc, RqXArray[Ind]);
            //      
            RqZArray[Ind] := RqYArray[Ind] - SIN(RqXArray[Ind]);
         end;
   'C' : begin
            //   COS
            RqYArray[Ind] := TaylorFunc(RqFunc, RqXArray[Ind]);
            //      
            RqZArray[Ind] := RqYArray[Ind] - COS(RqXArray[Ind]);
         end;
   'I' : begin
            //   SI ( )
            RqYArray[Ind] := TaylorFunc(RqFunc, RqXArray[Ind]);
            //  Delphi     
            RqZArray[Ind] := 0;
         end;
         else begin
            //     
            RqYArray[Ind] := 0;
            RqZArray[Ind] := 0;
         end;
   end;
   //      
   RqZArray[Ind] := RqYArray[Ind] - SIN(RqXArray[Ind]);
 end;
end;

// =========================================================
//    ( )
// =========================================================
begin
  { TODO -oUser -cConsole Main : Insert code here }
// 
  WriteLn  ('==========================================');
  WriteLnRus ('     ');
  WriteLn  ('==========================================');
  ShowMenu;
  repeat
    WriteRus (' /IMPUT COMMAND : ');
    ReadLn(CmdChar);
    CmdChar:=UpCase(CmdChar);
    case CmdChar of
    'H': begin ShowMenu(); end;
    'V': begin ShowArrayXY(XArray, YArray); end;
    'W': begin DWriteToArray(XArray); end;
    'R': begin
            WriteRandomToArray(2* Pi/360 , 360, XArray);
            ShowArray(XArray);
         end;
    'S': begin
             TaylorFuncToYArray ('S', XArray, YArray, ZArray);
             ShowArrayXYZ(XArray, YArray, ZArray);
         end;
    'C': begin
             TaylorFuncToYArray ('C', XArray, YArray, ZArray);
             ShowArrayXYZ(XArray, YArray, ZArray);
         end;
    'E': begin
             TaylorFuncToYArray ('E', XArray, YArray, ZArray);
             ShowArrayXYZ(XArray, YArray, ZArray);
         end;
    'I': begin
             TaylorFuncToYArray ('I', XArray, YArray, ZArray);
             ShowArrayXY(XArray, YArray);
         end;
    'M': begin FindAndShowArrayMinMax(XArray);  end;
    '+': begin
            SortArray('U', XArray);
            ShowArray(XArray);
         end;
    '-': begin
            SortArray('D', XArray);
            ShowArray(XArray);
         end;
    else begin
           WriteLnRus(#09 + '( )/ERROR(Unknown command)');
         end;
    end;
  until ('Q' = CmdChar);

end.


